*******************************************************
* SPEECH.SRC                                          *
*                                                     *
* This program has two entry points:                  *
*                                                     *
*        RECORD   - $8000                             *
*        PLAY     - $800C                             *
*                                                     *
* The RECORD routine digitizes speech from the        *
* ADC0804 and stores the samples in a RAM buffer.     *
*                                                     *
* The PLAY routine outputs samples from the RAM       *
* buffer to the MC1408L8.                             *
*                                                     *
* The sample rate is 3686400 / 32 / COUNT = 8862 Hz.  *
* The RAM buffer is 12K, starting at $8400.           *
*******************************************************
DUART    EQU      $00C001 ;68681 base address
ACR      EQU      4*2     ;auxiliary control register
CTUR     EQU      6*2     ;counter/timer upper register
CTLR     EQU      7*2     ;counter/timer lower register
IMR      EQU      5*2     ;interrupt mask register
IVR      EQU      12*2    ;interrupt vector register
STOP     EQU      15*2    ;timer stop command address
PIA      EQU      $010001 ;PIA base address
CRA      EQU      1*2     ;Control Register A
PORTB    EQU      2*2     ;Port B / DDRB
CRB      EQU      3*2     ;Control Register B
I2VECTOR EQU      26      ;I2 autovector number
SAMPLES  EQU      $8400   ;sample buffer
SIZE     EQU      1024*12 ;12K sample buffer
COUNT    EQU      15      ;interrupts @ 7680 Hz


         ORG      $8000
SPEECH   JMP      RECORD
         JMP      L2ISR
PLAY     MOVE.B   #0,D7         ;D7[0] = 0 = "play"
         BRA.S    AHEAD
RECORD   MOVE.B   #1,D7         ;D7[0] = 1 = "record"
* init 68681 DUART
AHEAD    MOVEA.L  #DUART,A0     ;A0 -> 68681 DUART
         MOVE.B   #$08,IMR(A0)
         MOVE.B   #I2VECTOR,IVR(A0)
         MOVE.W   #COUNT,D0
         MOVEP.W  D0,CTUR(A0)
         MOVE.B   #$70,ACR(A0)
* init 6821 PIA
         MOVEA.L  #PIA,A2       ;A2 -> 6821 PIA
         MOVE.B   #$FF,(A2)     ;Port A = output
         MOVE.B   #$04,CRA(A2)  ;enable Port A
         MOVE.B   #$3C,CRB(A2)  ;enable Port B
         MOVEA.L  #SAMPLES,A1   ;A1 -> sample buffer
         ORI.W    #$0700,SR     ;mask all interrupts
         ANDI.W   #$F9FF,SR     ;mask level 1 only
* off we go!
AGAIN    CMPA.L   #SAMPLES+SIZE,A1   ;end of buffer?
         BNE      AGAIN              ;no:  check again
         ORI.W    #$0700,SR          ;yes: done
         TRAP     #14                ;return to MON68K

*******************************************************
* LEVEL-2 INTERRUPT SERVICE ROUTINE                   *
*                                                     *
*        -issue STOP command to clear interrupt       *
*        -check for PLAY vs. RECORD                   *
*        -if PLAY: get a sample from RAM buffer and   *
*         send it to Port A (MC1408L8)                *
*        -if RECORD: input a sample from ADC0804,     *
*         store it in the RAM buffer, and pulse /WR   *
*         for 8 us to begin next conversion           *
*******************************************************
L2ISR    TST.B    STOP(A0)      ;stop cmd, clrs intrrpt
         BTST     #0,D7         ;play or record?
         BNE      R_ISR         ;1 = record
P_ISR    MOVE.B   (A1)+,D0      ;0 = play (get sample)
         MOVE.B   D0,(A2)       ;send it
         RTE

R_ISR    MOVE.B   PORTB(A2),D0  ;get sample
         MOVE.B   D0,(A1)+      ;put in buffer
         MOVE.B   #$34,CRB(A2)  ;start next conversion
         NOP                    ;streeeeee
         NOP                    ;    eeeeee
         NOP                    ;     eeeeee
         NOP                    ;      eeeeee
         NOP                    ;       eeeeee
         NOP                    ;        eeeeee
         NOP                    ;         eeeeeeeetch
         MOVE.B   #$3C,CRB(A2)  ;toggle CB2 for 8 us!
         RTE

         ORG      SAMPLES
         DS.B     SIZE          ;12 kbyte sample buffer
         END      SPEECH
